class Proj_Tower_Warlord extends Projectile;

var vector OriginalDirection;
var float Count,SmokeRate;

event ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.IsA('NoPlayerZone') )
		Self.Destroy();
}

function Explode(vector HitLocation, vector HitNormal)
{
local SpriteBallExplosion S;
local float MyDamage, MyRadius, MyScale;

	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel == 0 )
		{
		MyDamage = 15;
		MyRadius = 35;
		MyScale = 0.5;
		}
	else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel == 1 )
		{
		MyDamage = 25;
		MyRadius = 45;
		MyScale = 0.75;
		}
	else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel == 2 )
		{
		MyDamage = 35;
		MyRadius = 55;
		MyScale = 1.00;
		}
	else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel == 3 )
		{
		MyDamage = 45;
		MyRadius = 65;
		MyScale = 1.50;
		}
	HurtRadius(MyDamage, MyRadius, 'Tower', MomentumTransfer, HitLocation);
	S = Spawn(class'SpriteBallExplosion', Pawn(Owner),,HitLocation);
	S.DrawScale = MyScale;
	Destroy();
}


function Tick(float DeltaTime)
{

}

auto state Flying
{

	function ProcessTouch (Actor Other, Vector HitLocation)
		{
		if ( Other.IsA('Balloon') || Other == Level ) 
			Explode(HitLocation, vect(0,0,0));
		}


	function BeginState()
		{	
		PlaySound(SpawnSound);
		OriginalDirection = Vector(Rotation);	
		Velocity = OriginalDirection * 500.0;
		Acceleration = Velocity * 0.4;	
		}

Begin:
	Sleep(7.0);
	Explode(Location, vect(0,0,0));
}

defaultproperties
{
     speed=1200.000000
     MaxSpeed=1200.000000
     Damage=60.000000
     MomentumTransfer=20
     bNetTemporary=False
     AmbientSound=Sound'UnrealI.General.BRocket'
     Mesh=LodMesh'UnrealI.perock'
     DrawScale=2.500000
     AmbientGlow=1
     bUnlit=True
     SoundRadius=20
     SoundVolume=255
     bBounce=True
}
